local tonumber = tonumber

CategoryScaler = function(count, rectMin, rectSize, itemSpacing, itemCount, itemIndex)
    local itemCountForGroupSize = math.max(itemCount or 1, 1)
    itemSpacing = itemSpacing or 0
    itemCount = (itemIndex and itemCountForGroupSize) or 1
    itemIndex = itemIndex or 1
    local groupSpacing = 1 / math.max(itemCountForGroupSize, 2)
    local groupSize = rectSize / (count + count * groupSpacing)
    local itemSize = groupSize / (itemCount + (itemCount - 1) * itemSpacing)
    local A = rectMin - groupSize - groupSize * 0.5 * groupSpacing + (itemIndex - 0.5) * itemSize + (itemIndex - 1) * (itemSize * itemSpacing)
    local M = rectSize / count
    local SM = math.abs(itemSize)
    return function(value, size)
        value = tonumber(value)
        if value then
            if size then
                return A + M * value - SM * size / 2, A + M * value + SM * size / 2
            else
                return A + M * value
            end
        end
    end
end

return CategoryScaler
